  ' Micromite => EPAPER display demo
  
  OPTION EXPLICIT
  'interface pins, uses SPI (MISO 14, MOSI 3, SCLK 25) and...
  CONST EPAPERDC=4
  CONST EPAPERCS=5
  CONST EPAPERRESET=9
  CONST EPAPERBUSY=10
  
  ''UMITE:  3V3 GND 3   25  5   4   9   10
  ''EPAPER: 3V3 GND SDI SCK CS  D/C  RES BUSY
  
  DIM ORIENTATION,I,BITBUCKET AS INTEGER
  ORIENTATION = 0
  DIM INTEGER ARIAL16X24ADDRESS
  ARIAL16X24ADDRESS=PEEK(CFUNADDR ARIAL16X24)
  DIM INTEGER SMALLFONTADDRESS
  SMALLFONTADDRESS=PEEK(CFUNADDR SMALLFONT)
  DIM INTEGER APPLEIMAGEADDRESS
  APPLEIMAGEADDRESS=PEEK(CFUNADDR APPLEIMAGE)
  DIM INTEGER MUSHROOMIMAGEADDRESS
  MUSHROOMIMAGEADDRESS=PEEK(CFUNADDR MUSHROOMIMAGE)
  
  ''MAIN
  EPAPERINIT
  EPAPERSETFULLREFRESH
  EPAPERCLEAR(0)
  EPAPERUPDATESCREEN
  EPAPERSETPARTIALREFRESH
  
DO
  EPAPERCLEAR(&H22)              ''00100010 pattern
  EPAPERBOX(6,50,13,100,255)     ''white
  EPAPERBOX(13,100,20,150,&HAA)  ''10101010 pattern
  EPAPERBOX(10,75,15,125,0)      ''black
  EPAPERUPDATESCREEN

  PIN(EPAPERRESET)=0      ''go to low power idle mode
  SPI CLOSE
  PAUSE 5000
  EPAPERINIT
  EPAPERSETFULLREFRESH
  EPAPERSETORIENTATION(0)

  EPAPERCLEAR(0)  
  EPAPERSTRING(4,8,"WHITE ON",255,ARIAL16X24ADDRESS)
  EPAPERSTRING(7,40,"BLACK",255,ARIAL16X24ADDRESS)
  EPAPERSTRING(6,80,"WHITE ON BLACK",255,SMALLFONTADDRESS)
  EPAPERBOX(0,100,24,199,255)    ''set bottom half of screen to white
  EPAPERSTRING(4,108,"BLACK ON",0,ARIAL16X24ADDRESS)
  EPAPERSTRING(7,140,"WHITE",0,ARIAL16X24ADDRESS)
  EPAPERSTRING(6,180,"BLACK ON WHITE",0,SMALLFONTADDRESS)
  EPAPERUPDATESCREEN
  
  PIN(EPAPERRESET)=0      ''go to low power idle mode
  SPI CLOSE
  PAUSE 5000
  EPAPERINIT
  EPAPERSETFULLREFRESH
  EPAPERSETORIENTATION(0)
  
  EPAPERCLEAR(255)  
  EPAPERSTRING(4,0,"Chapter 1",0,ARIAL16X24ADDRESS)
  EPAPERSTRING(0,32,"Lorem ipsum dolor sit",0,SMALLFONTADDRESS)
  EPAPERSTRING(0,44,"amet, consectetur",0,SMALLFONTADDRESS)
  EPAPERSTRING(0,56,"adipiscing elit. Aenean",0,SMALLFONTADDRESS)
  EPAPERSTRING(0,68,"arcu augue, consectetur",0,SMALLFONTADDRESS)
  EPAPERSTRING(0,80,"eu sagittis vel,",0,SMALLFONTADDRESS)
  EPAPERSTRING(0,92,"pellentesque in justo.",0,SMALLFONTADDRESS)
  EPAPERSTRING(0,104,"Curabitur dignissim nisl",0,SMALLFONTADDRESS)
  EPAPERSTRING(0,116,"a augue luctus, sed",0,SMALLFONTADDRESS)
  EPAPERSTRING(0,128,"egestas erat dignissim.",0,SMALLFONTADDRESS)
  EPAPERSTRING(0,140,"Mauris neque lacus,",0,SMALLFONTADDRESS)
  EPAPERSTRING(0,152,"interdum et tellus et,",0,SMALLFONTADDRESS)
  EPAPERSTRING(0,164,"facilisis aliquet lorem.",0,SMALLFONTADDRESS)
  EPAPERSTRING(0,176,"Aliquam rhoncus vitae",0,SMALLFONTADDRESS)
  EPAPERSTRING(0,188,"tortor et porttitor.",0,SMALLFONTADDRESS)
  EPAPERUPDATESCREEN()
  
  PIN(EPAPERRESET)=0      ''go to low power idle mode
  SPI CLOSE
  PAUSE 5000
  EPAPERINIT
  EPAPERSETFULLREFRESH
  EPAPERSETORIENTATION(1)
  
  EPAPERCLEAR(255)  
  EPAPERSTRING(4,0,"Chapter",0,ARIAL16X24ADDRESS)
  EPAPERSTRING(0,56,"Lorem ipsum ",0,ARIAL16X24ADDRESS)
  EPAPERSTRING(0,80,"dolor sit   ",0,ARIAL16X24ADDRESS)
  EPAPERSTRING(0,104,"amet,       ",0,ARIAL16X24ADDRESS)
  EPAPERSTRING(0,128,"consectetur",0,ARIAL16X24ADDRESS)
  EPAPERSTRING(0,152,"adipiscing ",0,ARIAL16X24ADDRESS)
  EPAPERSTRING(0,176,"elit.",0,ARIAL16X24ADDRESS)
  EPAPERUPDATESCREEN
  
  PIN(EPAPERRESET)=0      ''go to low power idle mode
  SPI CLOSE
  PAUSE 5000
  EPAPERINIT
  EPAPERSETFULLREFRESH
  EPAPERSETORIENTATION(0)

  EPAPERCLEAR(255)  
  EPAPERSTRING(6,10,"APPLES",0,ARIAL16X24ADDRESS)
  EPAPERSTRING(4,187,"*Conditions apply",0,SMALLFONTADDRESS)
  EPAPERDRAWIMAGE(6,45,APPLEIMAGEADDRESS,0)
  EPAPERSTRING(4,150,"$3.99/kg",0,ARIAL16X24ADDRESS)
  EPAPERUPDATESCREEN
  
  PIN(EPAPERRESET)=0      ''go to low power idle mode
  SPI CLOSE
  PAUSE 5000
  EPAPERINIT
  EPAPERSETFULLREFRESH

  EPAPERCLEAR(255)  
  EPAPERSTRING(3,10,"MUSHROOMS",0,ARIAL16X24ADDRESS)
  EPAPERSTRING(4,187,"*Conditions apply",0,SMALLFONTADDRESS)
  EPAPERDRAWIMAGE(6,45,MUSHROOMIMAGEADDRESS,0)
  EPAPERSTRING(4,150,"$12/kg",0,ARIAL16X24ADDRESS)
  EPAPERSTRING(7,90,"SALE!",0,ARIAL16X24ADDRESS) 
  EPAPERUPDATESCREEN
  EPAPERSETPARTIALREFRESH
  PAUSE 500
  EPAPERCLEAR(255)  
  EPAPERSTRING(3,10,"MUSHROOMS",0,ARIAL16X24ADDRESS)
  EPAPERSTRING(4,187,"*Conditions apply",0,SMALLFONTADDRESS)
  EPAPERDRAWIMAGE(6,45,MUSHROOMIMAGEADDRESS,0)
  EPAPERSTRING(4,150,"$12/kg",0,ARIAL16X24ADDRESS)
  EPAPERSTRING(7,90,"SALE!",255,ARIAL16X24ADDRESS)
  EPAPERUPDATESCREEN
  PAUSE 500
  EPAPERUPDATESCREEN
  PAUSE 500
  EPAPERUPDATESCREEN
  PAUSE 500
  EPAPERUPDATESCREEN
  PAUSE 500
  EPAPERUPDATESCREEN
  PAUSE 500
  EPAPERUPDATESCREEN
  PAUSE 500
  EPAPERUPDATESCREEN
  
  PIN(EPAPERRESET)=0      ''go to low power idle mode
  SPI CLOSE
  PAUSE 500
  EPAPERINIT
  EPAPERSETFULLREFRESH
  
LOOP
END  
  
SUB EPAPERINIT
  SPI OPEN 4000000, 0, 8    '4MHz max, datasheet specs 250ns minimum clock cycle time
  PIN(EPAPERRESET)=1
  PIN(EPAPERDC)=1
  PIN(EPAPERCS)=1
  SETPIN EPAPERRESET,DOUT
  SETPIN EPAPERDC,DOUT
  SETPIN EPAPERCS,DOUT
  SETPIN EPAPERBUSY,DIN
  PIN(EPAPERRESET)=0
  PAUSE 100
  PIN(EPAPERRESET)=1
  PAUSE 100
  PIN(EPAPERCS)=0
  EPAPERCOMMAND(&H01)
  EPAPERDATA(&Hc7)''number of gates = 200
  EPAPERDATA(&H00)
  EPAPERDATA(&H00)
  EPAPERCOMMAND(&H3A)''dummy line period=0x1A per sample code
  EPAPERDATA(&H1A)
  EPAPERCOMMAND(&H3B)''gate line width=0x8 per sample code
  EPAPERDATA(&H08)
  EPAPERCOMMAND(&H2C)''VCOM=0x9B per sample code
  EPAPERDATA(&H9B)
  PIN(EPAPERCS)=1
  EPAPERSETORIENTATION(0)
END SUB
  
SUB EPAPERSETORIENTATION(o as INTEGER)
  if o=0 THEN   ''normal
    PIN(EPAPERCS)=0
    EPAPERCOMMAND(17)
    EPAPERDATA(0)
    PIN(EPAPERCS)=1
    ORIENTATION=0
  ENDIF
  if o=1 THEN  ''rotated 180
    PIN(EPAPERCS)=0
    EPAPERCOMMAND(17)
    EPAPERDATA(3)
    PIN(EPAPERCS)=1
    ORIENTATION=1
  ENDIF
END SUB
  
SUB EPAPERCOMMAND(D AS INTEGER)    'toggle DC and send data
  DO WHILE(PIN(EPAPERBUSY)>0)   'allow any operation to complete
    PRINT "WAIT:0x";HEX$(D);"  BUSY=";  PIN(EPAPERBUSY)
    PAUSE 200
  LOOP
  PIN(EPAPERDC)=0
  SPI WRITE 1,D
  PIN(EPAPERDC)=1
  'PRINT "C:";D
END SUB
  
SUB EPAPERDATA(D AS INTEGER)
  SPI WRITE 1,D
  'PRINT "D:";D
END SUB
  
SUB  EPAPERSETFULLREFRESH
  PIN(EPAPERCS)=0
  EPAPERCOMMAND(&H32)
  EPAPERDATA(&H50)
  EPAPERDATA(&HAA)
  EPAPERDATA(&H55)
  EPAPERDATA(&HAA)
  EPAPERDATA(&H11)
  EPAPERDATA(&H00)
  EPAPERDATA(&H00)
  EPAPERDATA(&H00)
  EPAPERDATA(&H00)
  EPAPERDATA(&H00)
  EPAPERDATA(&H00)
  EPAPERDATA(&H00)
  EPAPERDATA(&H00)
  EPAPERDATA(&H00)
  EPAPERDATA(&H00)
  EPAPERDATA(&H00)
  EPAPERDATA(&H00)
  EPAPERDATA(&H00)
  EPAPERDATA(&H00)
  EPAPERDATA(&H00)
  EPAPERDATA(&HFF)
  EPAPERDATA(&HFF)
  EPAPERDATA(&H1F)
  EPAPERDATA(&H00)
  EPAPERDATA(&H00)
  EPAPERDATA(&H00)
  EPAPERDATA(&H00)
  EPAPERDATA(&H00)
  EPAPERDATA(&H00)
  EPAPERDATA(&H00)
  PIN(EPAPERCS)=1
END SUB
  
SUB  EPAPERCLEAR(COL AS INTEGER)
  EPAPERSETAREA(0,0,24,199)
  PIN(EPAPERCS)=0
  FOR I = 0 to 4999
    EPAPERDATA(COL)
  NEXT I
  PIN(EPAPERCS)=1
END SUB
  
SUB  EPAPERUPDATESCREEN
  PIN(EPAPERCS)=0
  EPAPERCOMMAND(&H0c)''Booster soft start per sample code
  EPAPERDATA(&Hd7)
  EPAPERDATA(&Hd6)
  EPAPERDATA(&H9d)
  EPAPERCOMMAND(&H22)
  EPAPERDATA(&HC4)
  EPAPERCOMMAND(&H20)
  EPAPERCOMMAND(&HFF)
  PIN(EPAPERCS)=1
END SUB
  
SUB  EPAPERSETPARTIALREFRESH
  PIN(EPAPERCS)=0
  EPAPERCOMMAND(&H32)
  EPAPERDATA(&H10)
  EPAPERDATA(&H18)
  EPAPERDATA(&H18)
  EPAPERDATA(&H08)
  EPAPERDATA(&H18)
  EPAPERDATA(&H18)
  EPAPERDATA(&H08)
  EPAPERDATA(&H00)
  EPAPERDATA(&H00)
  EPAPERDATA(&H00)
  EPAPERDATA(&H00)
  EPAPERDATA(&H00)
  EPAPERDATA(&H00)
  EPAPERDATA(&H00)
  EPAPERDATA(&H00)
  EPAPERDATA(&H00)
  EPAPERDATA(&H00)
  EPAPERDATA(&H00)
  EPAPERDATA(&H00)
  EPAPERDATA(&H00)
  EPAPERDATA(&H13)
  EPAPERDATA(&H14)
  EPAPERDATA(&H44)
  EPAPERDATA(&H12)
  EPAPERDATA(&H00)
  EPAPERDATA(&H00)
  EPAPERDATA(&H00)
  EPAPERDATA(&H00)
  EPAPERDATA(&H00)
  EPAPERDATA(&H00)
  PIN(EPAPERCS)=1
END SUB
  
SUB EPAPERSETAREA(x0 AS INTEGER,y0 AS INTEGER,x1 AS INTEGER,y1 AS INTEGER){
  LOCAL intEGER t
  if x1<x0 THEN t=x1:x1=x0:x0=t
  if y1<y0 THEN t=y1:y1=y0:y0=t
  if orientation = 0 THEN
    x0=24-x0
    x1=24-x1
    y0=199-y0
    y1=199-y1
  ENDIF
  PIN(EPAPERCS)=0
  EPAPERCOMMAND(&H44)      ''set ram x range
  EPAPERDATA(x0 AND 31)  ''start (blocks of 8)
  EPAPERDATA(x1 AND 31)  ''end (blocks of 8
  EPAPERCOMMAND(&H45)      ''set ram y range
  EPAPERDATA(y0 AND 255) ''LSB start
  EPAPERDATA(0)        ''MSB start (will be 0 for <256)
  EPAPERDATA(y1 AND 255) ''LSB end
  EPAPERDATA(&H0)      ''MSB end (will be 0 for <256)
  EPAPERCOMMAND(&H4E)      ''set ram X address
  EPAPERDATA(x0 AND 31)  ''position
  EPAPERCOMMAND(&H4F)      ''set ram y address
  EPAPERDATA(y0 AND 255) ''LSB
  EPAPERDATA(&H0)      ''MSB
  EPAPERCOMMAND(&H24)      ''Start RAM write
  PIN(EPAPERCS)=1
END SUB
  
  
SUB EPAPERBOX(x0 AS INTEGER, y0 AS INTEGER, x1 AS INTEGER, y1 AS INTEGER, COL AS INTEGER)
  LOCAL INTEGER I,T
  T = (abs(x1-x0)+1)*(abs(y1-y0)+1)
  EPAPERSETAREA(x0,y0,x1,y1)
  PIN(EPAPERCS)=0
  FOR I = 0 to T-1
    EPAPERDATA(COL)
  NEXT I
  PIN(EPAPERCS)=1
END SUB
  
FUNCTION EPAPERCHAR(x as INTEGER, y AS INTEGER, C AS INTEGER, COL AS INTEGER, FONT AS INTEGER)
  LOCAL INTEGER WIDTH, HEIGHT, I,C0,C1
  WIDTH=PEEK(BYTE FONT)\8   ''groups of 8 monochrome pixels
  EPAPERCHAR=WIDTH          ''return number of columns written
  HEIGHT=PEEK(BYTE FONT+1)
  C0=PEEK(BYTE FONT+2)
  C1=C0+PEEK(BYTE FONT+3)-1
  IF C < C0 THEN C=C0       ''keep within character range
  IF C > C1 THEN C=C0       ''keep within character range
  C=C-C0                    ''map to font
  COL=COL XOR 255           ''map to font colour logic
  EPAPERSETAREA(x,y,x+width-1,y+height-1)
  PIN(EPAPERCS)=0
  FOR I = 0 TO WIDTH*HEIGHT-1
    EPAPERDATA(PEEK(BYTE FONT+4+WIDTH*HEIGHT*C+I) XOR COL)
  NEXT I
  PIN(EPAPERCS)=1
END FUNCTION
  
SUB EPAPERSTRING(x as INTEGER, y AS INTEGER, S AS STRING, SCOL AS INTEGER, FONT AS INTEGER)
  LOCAL INTEGER I,CTEMP,YTEMP
  FOR I= 1 TO LEN(S)
    CTEMP=SCOL      ''because COL gets modified, we need to restore it
    YTEMP=y         ''Y getting modified in setarea
    x=x+EPAPERCHAR(x ,YTEMP ,ASC(MID$(S,I,1)) ,CTEMP ,FONT)
  NEXT I
END SUB
  
SUB EPAPERDRAWIMAGE(x as INTEGER, y AS INTEGER, IM AS INTEGER, COL AS INTEGER)
  LOCAL INTEGER WIDTH, HEIGHT,I
  WIDTH=((PEEK(BYTE IM)+31)\32)*4   ''groups of 32 pixel words
  HEIGHT=PEEK(BYTE IM+1)
  COL=COL XOR 255           ''map to font colour logic
  EPAPERSETAREA(x,y,x+width-1,y+height-1)
  PIN(EPAPERCS)=0
  FOR I = 0 to WIDTH*HEIGHT-1
    EPAPERDATA(PEEK(BYTE IM+4+I) XOR COL)
  NEXT I
  PIN(EPAPERCS)=1
END SUB
  
  ''font data, each line is one character
CFunction ARIAL16X24      'not an actual CFUNCTION, but an array to read data direct from flash
  00000000    ''offset in 32bit words, set to zero to start below
  
  5F201810 ''font info, little endian, width, height, first char, num of chars
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  C0038001 C003C003 C003C003 C003C003 8003C003 80018001 00008001 80010000 C003C003 00008001 00000000 00000000
  00000000 30063006 600C600C 700E700E 00003006 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 18031803 38073807 FC3FFC3F 700E7006 600E700E FC3FFC3F E01CE01C C018C01C 0000C018 00000000 00000000
  80018001 F01FC007 B83DF81F 9839B839 801F803D F803F00F 9C31BC01 9C399C39 F81FB83D 8001E007 80018001 00000000
  10780000 20CC30F8 40CC60CC 80CCC0CC 3C018079 66026603 660C6606 3C18660C 00003C10 00000000 00000000 00000000
  00000000 00000000 C00F8007 E01CE01C C00FE01C 081F0007 D8719C3B F070F871 DE3FFC78 00008C0F 00000000 00000000
  C000E000 8001C001 00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  C0004000 8001C001 80038003 00070007 00070007 00070007 00070007 80038003 C0018001 4000C000 00000000 00000000
  00030002 80018003 C001C001 E000E000 E000E000 E000E000 E000E000 C001C001 80038001 00020003 00000000 00000000
  00000000 00000000 00000000 C0000000 C000C000 F807D806 E001C000 10033003 00000000 00000000 00000000 00000000
  00000000 00000000 00000000 80018001 80018001 F81FF81F 80018001 80018001 00000000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000 80030003 80018003 00038001 00000000
  00000000 00000000 00000000 00000000 00000000 F00FF00F 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000 80038003 00008003 00000000 00000000
  70003000 60007000 E000E000 C000E000 C001C001 8001C001 80038003 00038003 00070007 00000006 00000000 00000000
  
  E0070000 F81FF00F 1C38381C 1C381C38 1C381C38 1C381C38 1C381C38 381C1C38 F00FF81F 0000E007 00000000 00000000
  60000000 E001E000 E007E003 E01CE01F E000E018 E000E000 E000E000 E000E000 E000E000 0000E000 00000000 00000000
  E0070000 F81FF81F 1C383C3C 1C001C38 78003800 E003F000 000F8007 003C001E FC3FF83F 0000FC3F 00000000 00000000
  E0070000 F81FF00F 3838783C 78003800 F001F001 3C00F800 1C381C30 783C3C38 F00FF81F 0000E007 00000000 00000000
  60000000 F000F000 F003F001 70077003 700C700E 7038701C FC3F7038 7000FC3F 70007000 00007000 00000000 00000000
  FC1F0000 F81FFC1F 001C001C E01F001C F81FF01F 1C003C1C 1C001C00 383C1C38 F01FF83F 0000E007 00000000 00000000
  E0030000 F81FF00F 183C381C 00380038 F03FE03B 3C3CF83F 1C381C38 3C1C1C38 F00FF81F 0000E003 00000000 00000000
  FC3F0000 FC1FFC3F 70003800 E0007000 C001C001 80038003 80078003 00070007 00070007 00000006 00000000 00000000
  E0070000 F81FF00F 381C781E 781E381C F00FF00F 1C38381C 1C381C38 3C3C1C38 F00FF81F 0000E007 00000000 00000000
  C0070000 F81FF00F 1C38383C 1C381C38 FC1F3C3C DC07FC0F 1C001C00 381C3C18 F00FF81F 0000C007 00000000 00000000
  00000000 00000000 80030000 80038003 00000000 00000000 00000000 80038003 00008003 00000000 00000000 00000000
  00000000 00000000 00000000 80030000 80038003 00000000 00000000 00000000 80030003 80018003 00038001 00000002
  00000000 00000000 38000800 F803F800 001FC00F 001F001C F803C00F 3800F800 00000800 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 FC3FFC3F 0000FC3F FC3F0000 FC3FFC3F 00000000 00000000 00000000 00000000
  00000000 00100000 001F001C F003C01F 3800F800 F003F800 001FC01F 0010001C 00000000 00000000 00000000 00000000
  F00FC007 783CF01F 38383838 70003830 E001F000 8003C003 00018003 80030000 80038003 00008003 00000000 00000000
  
  00000000 00000000 F80FE003 04101C1C F227B623 625C724C 62586258 EC586458 7027F86F 0C180630 F003FC0F 00000000
  00000000 C0038001 E007C003 600EE007 700E700E 381C781C FC3F381C 1C38FC3F 0E700E70 00000E60 00000000 00000000
  00000000 F03FE03F 38387838 38383838 F03F3838 3838F03F 1C381C38 1C381C38 F83F3C38 0000F03F 00000000 00000000
  00000000 F00FE007 3C3C781E 0C781C38 00700070 00700070 0C700C70 3C3C1C38 F00F781E 0000E007 00000000 00000000
  00000000 F03FC03F 7838F038 1C383838 1C381C38 1C381C38 1C381C38 78383838 F03FF038 0000C03F 00000000 00000000
  00000000 FC1FFC1F 001C001C 001C001C F81F001C 001CF81F 001C001C 001C001C FC1F001C 0000FC1F 00000000 00000000
  00000000 FC0FFC0F 000E000E 000E000E F80F000E 000EF80F 000E000E 000E000E 000E000E 0000000E 00000000 00000000
  00000000 F80FE003 1C383C1C 0C700E38 00700070 FE70FE70 0E700E70 0E380E38 FC0F3E1C 0000F003 00000000 00000000
  00000000 1C381C38 1C381C38 1C381C38 FC3F1C38 1C38FC3F 1C381C38 1C381C38 1C381C38 00001C38 00000000 00000000
  00000000 80038003 80038003 80038003 80038003 80038003 80038003 80038003 80038003 00008003 00000000 00000000
  00000000 E000E000 E000E000 E000E000 E000E000 E000E000 E070E070 E079E070 C03FC03F 0000000F 00000000 00000000
  00000000 1C380C38 78383C38 E039F038 C03FC03B F03EE03F 7838703C 3C383C38 0E381E38 00000E38 00000000 00000000
  00000000 001C001C 001C001C 001C001C 001C001C 001C001C 001C001C 001C001C F81F001C 0000F81F 00000000 00000000
  00000000 1FF81FF8 3FFC3FFC 37EC3FFC 77EE77EE 67E677EE E7E7E7E7 C7E3E7E7 C7E3C7E3 000087E1 00000000 00000000
  00000000 1C3C1C18 1C3E1C3C 1C3F1C3E 9C3B1C3B DC399C39 FC38DC38 7C387C38 3C383C38 00001C38 00000000 00000000
  00000000 F00FE007 3C3CF81F 1E781C38 0E700E70 0E700E70 1E780E70 3C3C1C38 F00FF81F 0000E007 00000000 00000000
  
  00000000 F83FF03F 1C383C38 1C381C38 38381C38 E03FF83F 00380038 00380038 00380038 00000038 00000000 00000000
  00000000 F00FE007 3C3CF81F 0E781C38 0E700E70 0E700E70 9E790E70 7C3CFC38 FE0FF81F 0700EF07 00000000 00000000
  00000000 FC3FF83F 0E381E38 0E380E38 FC3F1E38 E038F03F 78387038 3C383C38 0E381E38 00000E38 00000000 00000000
  00000000 F01FE007 3838381C 003C1838 E01F003F F801F80F 1C303C00 1C381C38 F81F383C 0000E007 00000000 00000000
  00000000 FC7FFC7F 80038003 80038003 80038003 80038003 80038003 80038003 80038003 00008003 00000000 00000000
  00000000 1C381C38 1C381C38 1C381C38 1C381C38 1C381C38 1C381C38 383C1C38 F00FF81F 0000E007 00000000 00000000
  00000000 0E380638 1C1C0E38 1C1C1C1C 380E180E 300E380E 70077007 E0036007 C003E003 0000C001 00000000 00000000
  00000000 C3C383C1 C7E3C7E3 C663C7E3 66666666 6E766E76 3C3C6C36 3C3C3C3C 381C3C3C 00001818 00000000 00000000
  00000000 1E380C30 3C1C1C3C F00F781E E007F007 E007C003 F81FF00F 3C3C781E 1E781E78 00000E70 00000000 00000000
  00000000 1C781830 383C3838 F01E701C C007E00E 8003C007 80038003 80038003 80038003 00008003 00000000 00000000
  00000000 F83FF83F 78007800 F001F000 C003E001 80078007 001E000F 003C001E FC7F0078 0000FC7F 00000000 00000000
  E0010000 8001E001 80018001 80018001 80018001 80018001 80018001 80018001 80018001 80018001 E001E001 00000000
  00000000 001E000C 000F000E 00070007 80038007 C0038003 C001C001 E000E001 F000E000 00007000 00000000 00000000
  800F0000 8001800F 80018001 80018001 80018001 80018001 80018001 80018001 80018001 80018001 800F800F 00000000
  00000000 80078003 C0078007 E00CC00E 601CE01C 00007038 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000 FFFF0000 00000000 00000000
  
  00000000 003E001C 00630063 003E0063 0000001C 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 00000000 00000000 C00F0000 7018E01F F0007010 701EF00F 70387038 F01FF038 0000380E 00000000 00000000
  00000000 001C001C 001C001C F01D001C 381EF81F 1C1C1C1E 1C1C1C1C 1C1E1C1C F81F381E 0000E01D 00000000 00000000
  00000000 00000000 00000000 C0070000 701CF00F 1038383C 00380038 383C1038 F00F781C 0000C007 00000000 00000000
  00000000 38003800 38003800 B80F3800 781CF81F 38387838 38383838 78383838 F81F781C 0000B807 00000000 00000000
  00000000 00000000 00000000 C0070000 701CE00F 38383838 F03FF83F 10380038 F00F381C 0000C007 00000000 00000000
  00000000 E007E003 00070007 C01F0007 0007C01F 00070007 00070007 00070007 00070007 00000007 00000000 00000000
  00000000 00000000 00000000 B80F0000 781CF81F 38383838 38383838 38383838 F81F781C 3810B807 701C3838 C007F01F
  00000000 00380038 00380038 C03B0038 F03CE03F 70387038 70387038 70387038 70387038 00007038 00000000 00000000
  00000000 80038003 00008003 80030000 80038003 80038003 80038003 80038003 80038003 00008003 00000000 00000000
  00000000 80038003 00008003 80030000 80038003 80038003 80038003 80038003 80038003 80038003 80038003 001F801F
  00000000 000E000E 000E000E 180E000E 700E380E C00FE00E 700FE00F 380E700E 1C0E380E 00000C0E 00000000 00000000
  00000000 80038003 80038003 80038003 80038003 80038003 80038003 80038003 80038003 00008003 00000000 00000000
  00000000 00000000 00000000 9EEF0000 E7F1FFFF C7E1C7E1 C7E1C7E1 C7E1C7E1 C7E1C7E1 0000C7E1 00000000 00000000
  00000000 00000000 00000000 E01D0000 781EF01F 381C381C 381C381C 381C381C 381C381C 0000381C 00000000 00000000
  00000000 00000000 00000000 800F0000 E038C01F 70707070 70707070 70707070 C01FE038 0000800F 00000000 00000000
  
  00000000 00000000 00000000 C03B0000 703CF03F 3838383C 38383838 383C3838 F03F703C 0038C03B 00380038 00380038
  00000000 00000000 00000000 B8070000 781CF81F 38387838 38383838 78383838 F81F781C 3800B807 38003800 38003800
  00000000 00000000 00000000 E00E0000 100FF00F 000E000E 000E000E 000E000E 000E000E 0000000E 00000000 00000000
  00000000 00000000 00000000 C0070000 701CF00F 001F301C F003E00F 381C7800 F00F381E 0000E007 00000000 00000000
  00000000 80038003 80038003 E0078003 8003E00F 80038003 80038003 80038003 F0038003 0000F001 00000000 00000000
  00000000 00000000 00000000 381C0000 381C381C 381C381C 381C381C 381C381C F80F781E 0000B807 00000000 00000000
  00000000 00000000 00000000 18180000 381C381C 700E300C 6006700E C003E007 C003C003 00008001 00000000 00000000
  00000000 00000000 00000000 83C10000 C7E3C7E3 E667C663 6C366E76 7C3E6C36 381C381C 0000381C 00000000 00000000
  00000000 00000000 00000000 38380000 F01E783C C007E00F E00FC007 F01EE00E 3838783C 00003830 00000000 00000000
  00000000 00000000 00000000 18180000 381C381C 700E300C 6006700E E0076007 C003C003 8001C003 80038003 001E001F
  00000000 00000000 00000000 F83F0000 7800F83F E001F000 8007C003 000E0007 F83F001E 0000F83F 00000000 00000000
  F0007000 C001F001 C001C001 C001C001 8003C001 80078007 C0018003 C001C001 C001C001 F001C001 7000F000 00000000
  80038003 80038003 80038003 80038003 80038003 80038003 80038003 80038003 80038003 80038003 80038003 00000000
  001E001C 0007001F 00070007 00070007 80030007 C003C003 00078003 00070007 00070007 001F0007 001C001E 00000000
  00000000 081E0000 F83FF83F 0000F020 00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
End CFunction
  
  ''font data, each line is one character
CFunction SMALLFONT      'not an actual CFUNCTION, but an array to read data direct from flash
  00000000    ''offset in 32bit words, set to zero to start below
  5F200C08 ''font info, little endian, width, height, first char, num of chars
  00000000 	00000000 	00000000
  20200000 	20202020 	00002000
  50502800 	00000000 	00000000
  28280000 	FC5028FC 	00005050
  A8782000 	283060A0 	0020F0A8
  A8480000 	342850B0 	00004854
  50200000 	A8A87850 	00006C90
  80404000 	00000000 	00000000
  10080400 	10101010 	00040810
  10204000 	10101010 	00402010
  20000000 	A87070A8 	00000020
  20200000 	2020F820 	00000020
  00000000 	00000000 	80404000
  00000000 	0000F800 	00000000
  00000000 	00000000 	00004000
  10100800 	40202010 	00804040
  
  88700000 	88888888 	00007088
  60200000 	20202020 	00007020
  88700000 	40201088 	0000F880
  88700000 	08083008 	00007088
  30100000 	78905050 	00001810
  80F80000 	0808F080 	00007088
  90700000 	8888F080 	00007088
  90F80000 	20202010 	00002020
  88700000 	88887088 	00007088
  88700000 	08788888 	00007048
  00000000 	00000020 	00002000
  00000000 	00002000 	00202000
  10080400 	10204020 	00000408
  00000000 	F80000F8 	00000000
  10204000 	10080408 	00004020
  88700000 	20201088 	00002000
  
  88700000 	B8A8A898 	00007880
  20200000 	78505030 	0000CC48
  48F00000 	48487048 	0000F048
  88780000 	80808080 	00007088
  48F00000 	48484848 	0000F048
  48F80000 	40507050 	0000F848
  48F80000 	40507050 	0000E040
  48380000 	889C8080 	00003048
  48CC0000 	48487848 	0000CC48
  20F80000 	20202020 	0000F820
  107C0000 	10101010 	00E09010
  48EC0000 	50506050 	0000EC48
  40E00000 	40404040 	0000FC44
  D8D80000 	A8A8D8D8 	0000A8A8
  48DC0000 	58586868 	0000E848
  88700000 	88888888 	00007088
  
  48F00000 	40407048 	0000E040
  88700000 	E8888888 	00187098
  48F00000 	48507048 	0000EC48
  88780000 	08106080 	0000F088
  A8F80000 	20202020 	00007020
  48CC0000 	48484848 	00003048
  48CC0000 	30505048 	00002020
  A8A80000 	505070A8 	00005050
  50D80000 	50202050 	0000D850
  50D80000 	20202050 	00007020
  90F80000 	40202010 	0000F848
  20203800 	20202020 	00382020
  40404000 	10102020 	00000810
  10107000 	10101010 	00701010
  00502000 	00000000 	00000000
  00000000 	00000000 	FC000000
  
  00002000 	00000000 	00000000
  00000000 	38483000 	00003C48
  40C00000 	48487040 	00007048
  00000000 	40483800 	00003840
  08180000 	48483808 	00003C48
  00000000 	78483000 	00003840
  201C0000 	20207820 	00007820
  00000000 	30483C00 	38447840
  40C00000 	48487040 	0000EC48
  00200000 	20206000 	00007020
  00100000 	10103000 	E0101010
  40C00000 	70505C40 	0000EC48
  20E00000 	20202020 	0000F820
  00000000 	A8A8F000 	0000A8A8
  00000000 	4848F000 	0000EC48
  00000000 	48483000 	00003048
  
  00000000 	4848F000 	E0407048
  00000000 	48483800 	1C083848
  00000000 	4060D800 	0000E040
  00000000 	30407800 	00007808
  20000000 	20207020 	00001820
  00000000 	4848D800 	00003C48
  00000000 	5048EC00 	00002030
  00000000 	70A8A800 	00005050
  00000000 	2050D800 	0000D850
  00000000 	5048EC00 	C0202030
  00000000 	20107800 	00007820
  10101800 	10102010 	00181010
  10101010 	10101010 	10101010
  20206000 	20201020 	00602020
  0018A440 	00000000 	00000000
End CFunction
  
  ''image data, each line is one scanline
CFunction APPLEIMAGE      'not an actual CFUNCTION, but an array to read data direct from flash
  00000000    ''offset in 32bit words, set to zero to start below
  00005452          ''width and height
  F0070000 00000000 00000000
  FC3F0000 00000000 00000000
  07FC0000 00000000 00000000
  01F00100 00000080 00000000
  00E00300 00000040 00000000
  00800F00 00000020 00000000
  00001F00 000000F0 00000000
  0F003E00 000000FF 00000000
  3F007C00 000080FF 00000000
  FE00F800 0000C001 00000000
  F001E003 00206000 00000000
  C0078007 00703000 00000000
  001F007E 00F01000 00000000
  04FC003C 00F01100 00000000
  FFFFFF07 00E011C0 00000000
  FFFFFF01 00C013F0 00000000
  00FE7F00 00C0133C 00000000
  00000000 0080230E 00000000
  00000000 0080C303 00000000
  00000000 0000C700 00000000
  00000000 00001700 00000000
  00000000 00000700 00000000
  00000000 00000600 00000000
  00000000 0000067F 00000000
  03000000 0000FEFF 00000000
  0F000000 F9E3FFFF 000000F8
  3F000000 00FE03C0 0000000E
  7E000000 00600000 00008003
  FC010000 00000400 0000C000
  F0010000 00000000 00006000
  E0030000 00000000 00003000
  C0070000 00000000 00001800
  800F0000 00000000 00000C00
  801F0000 00000000 00000E00
  001F0000 00000000 00000600
  003E0000 00000000 00000700
  003E0000 00000000 00000300
  007E0000 00000000 00000300
  007C0000 00000000 00800300
  007C0000 00000000 00800300
  00F80000 00000000 00800100
  00F80000 00000000 00800100
  00F80000 00000000 00C00100
  00F80000 00000000 00C00100
  00F80000 00000000 00C00100
  00F80000 00000000 00C00100
  00F00000 00000000 00C00100
  00F00000 00000000 00C00100
  00F00000 00000000 00C00100
  00F80000 00000000 00C00100
  00F80000 00000000 00C00100
  00F80000 00000000 00C00100
  00F80000 00000000 00C00300
  00F80000 00000000 00C00300
  00F80000 00000000 00800300
  00F80000 00000000 00800300
  007C0000 00000000 00800300
  007C0000 00000000 00800700
  007C0000 00000000 00800700
  003E0000 00000000 00000700
  003E0000 00000000 00000F00
  003F0000 00000000 00000F00
  001F0000 00000000 00001E00
  001F0000 00000000 00001E00
  801F0000 00000000 00003C00
  C00F0000 00000000 00003C00
  C0070000 00000000 00007800
  E0070000 00000000 0000F800
  F0030000 00000000 0000F000
  F0030000 00000000 0000F001
  F8010000 00000000 0000E003
  FC000000 00000000 0000C007
  7E000000 00000000 0000800F
  3F000000 00000000 0000801F
  1F000000 00000080 0000003F
  0F000000 000000E0 000000FE
  07000000 030000F8 000000FC
  03000000 0F0000FE 000000F0
  01000000 7F00C0FF 000000E0
  00000000 FF9FFF7F 000000C0
  00000000 FFFFFF1F 00000000
  00000000 FCFFFF07 00000000
  00000000 E0FFFF01 00000000
  00000000 00FF1F00 00000000
End CFunction
  
  ''image data, each line is one scanline
CFunction MUSHROOMIMAGE      'not an actual CFUNCTION, but an array to read data direct from flash
  00000000    ''offset in 32bit words, set to zero to start below
  00005549
  00000000 00000000 00000000
  00000000 00000000 00000000
  00000000 0000007C 00000000
  0F000000 0000F0FF 00000000
  7F000000 0000FEFF 00000000
  F8010000 00807F00 00000000
  C0070000 00E00F00 00000000
  001E0000 00F00100 00000000
  00380000 00780000 00000000
  00700000 003E0000 00000000
  00E00000 001F0000 00000000
  00800100 800F0000 00000000
  00000300 80070000 00000000
  00000600 C0030000 00000000
  00000E00 E0010000 00000000
  00000C00 F0000000 00000000
  00001800 F0000000 00000000
  00003000 78000000 00000000
  00002000 38000000 00000000
  00006000 3C000000 00000000
  0000C000 1C000000 00000000
  00008000 0E000000 00000000
  00008001 0E000000 00000000
  00000001 07000000 00000000
  00000003 07000000 00000000
  00000002 03000000 00000000
  00000006 03000000 00000080
  00000004 03000000 00000080
  00000004 01000000 00000080
  0000000C 01000000 00000080
  0000000C 01000000 000000C0
  00000008 01000000 000000C0
  00000008 00000000 000000C0
  00000008 00000000 000000C0
  00000008 00000000 000000C0
  00000008 00000000 00000080
  FF01000C 0100E0FF 00000080
  C01F0004 0100FE7F 00000080
  00700004 01C00F00 00000000
  00800002 03700000 00000000
  00800003 06180000 00000000
  00800001 0C080000 00000000
  0000C000 18080100 00000000
  00002000 60080000 00000000
  00001800 80910000 00000000
  00040200 00840000 00000000
  00040000 00400000 00000000
  00000000 00400000 00000000
  00080000 00200000 00000000
  00080000 00300000 00000000
  00080000 00100000 00000000
  00100000 00180000 00000000
  00100000 000C0000 00000000
  00300000 000C0000 00000000
  00200000 00060000 00000000
  00200000 00060000 00000000
  00400000 00030000 00000000
  00400000 00030000 00000000
  00C00000 00030000 00000000
  00800000 80010000 00000000
  00800000 80010000 00000000
  00800100 80010000 00000000
  00800100 80010000 00000000
  00800100 80010000 00000000
  00800100 80010000 00000000
  00800100 80010000 00000000
  00800100 80010000 00000000
  00800100 80030000 00000000
  00800100 00030000 00000000
  00C00000 00030000 00000000
  00C00000 00070000 00000000
  00E00000 000E0000 00000000
  00700000 000E0000 00000000
  00380000 001C0000 00000000
  003C0000 00380000 00000000
  001E0000 00700000 00000000
  000F0000 00F00000 00000000
  C0070000 00C00300 00000000
  F8010000 00800F00 00000000
  FF000000 00007F80 00000000
  3F000000 0000FCFF 00000000
  07000000 0000E0FF 00000000
  00000000 00000018 00000000
  00000000 00000000 00000000
  00000000 00000000 00000000
End CFunction
